// JavaScript Document

/**FUNCTION shows/hides html elements due to the id*/
function show_hide(id)
{
	var object = document.getElementById(id);
	object.style.display = (object.style.display == "none") ? '' : 'none';
}

/**FUNCTION shows element*/
function element_show(id)
{
	var object = document.getElementById(id);
	object.style.display = '';
}

/**FUNCTION hides element*/
function element_hide(id)
{
	var object = document.getElementById(id);
	object.style.display = 'none';
}

/**FUNCTION changes the link decoration - magazine*/
function change_arrow(base, id, first, second)
{
	var object = document.getElementById(base);

	if (object.style.display == "none")
	{
		document.getElementById(id).setAttribute("class", first);
	}
	else
	{
		document.getElementById(id).setAttribute("class", second);
	}
}

/**FUNCTION shows/hides html elements and sets value for overtaking infos about data shown/hidden*/
function show_hide_on(id, id_on)
{
	var object_id = document.getElementById(id);
	var object_id_on = document.getElementById(id_on);
	object_id.style.display = (object_id.style.display == "none") ? '' : 'none';
	object_id_on.value = (object_id.style.display == "none") ? 0 : 1;
}

/**FUNCTION shows/hides html elements and sets value for overtaking infos about data shown/hidden*/
function show_hide_bookmark(name, id, amount)
{
	//LOOP
	for(var i = 1; i <= amount; i++)
	{
		var object_i = document.getElementById(name + i);
		object_i.style.display = 'none';
		//COLOR
		var object_i = document.getElementById(name + i + '_link');
		object_i.style.backgroundColor = '#999999';
		object_i.style.padding = '3px 8px';
	}
	//SHOW HIDE
	var object_id = document.getElementById(name + id);
	object_id.style.display = '';
	var object_id = document.getElementById(name + id + '_link');
	object_id.style.backgroundColor = '#5fb2d2';//'#D3D3D3';
	object_id.style.padding = '5px 8px';
}

/**FUNCTION increases the text size in particular element*/
function text_size_change(id, up)
{
	var max = 16; //max.
	var min = 10; //min.
	var amount_of_paragraphs = document.getElementById('amount_of_paragraphs').value;
	var font_size = parseInt(document.getElementById('text_0').style.fontSize.replace("px",""));
	size = font_size;
	size = (up == 1 && font_size < 16) ? (font_size + 2) : size;
	size = (up == 0 && font_size > 10) ? (font_size - 2) : size;
	//loop
	for(var i = 0; i <= amount_of_paragraphs; i++)
	{
		document.getElementById(id +'_' + i).style.fontSize = size + "px";
	}
}

/**funkce umoznuje vlozeni php vystupu do JavaScriptu volanim php stranky*/
function include_rpc(script_filename)
{
	var html_doc = document.getElementsByTagName('head').item(0);
	var js = document.createElement('script');
	js.setAttribute('language', 'javascript');
	js.setAttribute('type', 'text/javascript');
	js.setAttribute('src', script_filename);
	html_doc.appendChild(js);
	return false;
}

/**FUNCTION bookmarks the site*/
function bookmarksite(title,url)
{
	if(document.all)
	{
		window.external.AddFavorite(url,title);
	}
	else if(window.sidebar)
	{
		window.sidebar.addPanel(title,url,"");
	}
}

/**FUNCTION shows a dialogue and relinks the site to the target site if OK button chosen */
function relink_question(url, text)
{
	var question = confirm(text);
	if (question == true)
	{
		window.location.href = url;
	}
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

function showBanner(bannerPlace, positionId)
{
	$.getJSON("/api/banner.php?b=" + positionId, function(bannerData) {
		// Banner div
		var b = $(document.createElement('div'));
		b.addClass('banner');
		b.css('width', bannerData.width);
		b.css('height', bannerData.height);

		// Image banner
		if (bannerData.type == 'file') {

			// Flash
			if (bannerData.file.substr(-3) == 'swf') {
				var swf = new SWFObject(bannerData.file + "?clickTAG=http://praguepost.com/operation/banners_clicks.php", "fooBarId", bannerData.width, bannerData.height, "8", "#fff");
				swf.write(bannerPlace);
				return;
			} else {
				var a = $(document.createElement('a'));
				a.attr('href', bannerData.url);
				a.attr('target', '_blank');
				a.attr('onClick', "include_rpc('/operation/banners_clicks.php?data=" + bannerData.id + "&action');");

				var image = document.createElement('img');
				img = $(image);
				img.attr('src', bannerData.file);
				a.append(img);

				b.append(a);
			}

		} else if (bannerData.type == 'html') {
			b.html(bannerData.html);
		} else if (bannerData.type == 'text') {
			b.html(bannerData.text);
		}

		if (bannerData.id) {
			$('#' + bannerPlace).append(b);
		}

	});
}

function showLeadingStoriesTabs(leadingArticlesBoxId)
{
	$(leadingArticlesBoxId).load('/api/leading-stories.php', function() {
		animateTabs(leadingArticlesBoxId + " #tabs");
	});
}

function animateTabs(tabPanelId)
{
	$(tabPanelId).tabs({
		fx: {
			opacity: 'toggle'
		}
	});
	$(tabPanelId).tabs("rotate", 6000);
}
